
// -----------------------------------------------------------------------------------------
//                    T O W E R 
//------------------------------------------------------------------------------------------   

#declare p0     = 0.00   ;
#declare p1     = 48.00  ;
#declare p2     = 98.50  ;
#declare p3     = 107.50 ;
#declare p4     = 122.50 ;
#declare p5     = 137.50 ;
#declare p6     = 145.00 ;
#declare p7     = 192.00 ;
#declare p8     = 215.00 ;
#declare p9     = 223.50 ;
#declare p10    = 244.50 ;
#declare p11    = 278.50 ;
#declare p12    = 288.50 ;
#declare p13    = 308.50 ;
#declare p14    = 328.50 ;
#declare p15    = 348.50 ;
#declare p16    = 368.50 ;
#declare p17    = 388.00 ;
#declare p18    = 395.00 ;
#declare p19    = 441.00 ;

#declare rivotA = sphere {<0,0,0>,2 } 
#declare slot = box {<-1,-5,-100>,<1,100,100> }   
#declare rib = torus {51,2 rotate <90,0,0> }     //-- high collar corner

#declare tower_A =
union {
    cone {<0,p0,0>,65,<0,p9,0>,49 }     //-- tall base
    cylinder {<0,p9,0>,<0,p10,0>, 54}   //-- base high collar
    cylinder {<0,p8,0>,<0,p9,0>, 51}    //-- base low collar
    #for (i,0,11)
         object { rivotA translate <54,234,0> rotate <0,15+(i*30),0>}  //-- high collar rivots
    #end
    torus {50,4 translate <0,p10,0> }     //-- high collar corner
    torus {50,4 translate <0,p9,0> }      //-- high collar corner
    
    
    
    difference {   //-- tower dome with rimb
        union {
        sphere { <0,0,0>,1 scale <52,40,52>} 
        #for (i,0,15)
            object { rib translate <0,0,0> scale <1,.77,1> rotate <0,i*24,0> }
        #end
        }
        plane {<0,1,0>,0} 
        translate <0,p10,0>
    }  
    
    cone {<0,p11,0>,28,<0,p12,0>,25}                            //-- tower flange
    torus {26,3 translate <0,p11-1,0> }                         //-- tower flange
    torus {22,3 translate <0,p12-1,0> }     
    
    cone {<0,p12,0>,21,<0,p17,0>,16.5}                          //-- top tower 
    torus {14.5,2 translate <0,p17,0> }                         //-- top tower parapet 
    
    cone {<0,p17,0>,10,<0,p18,0>,8}                             //-- top tower nipple      
    sphere {<0,0,0>,8 scale <1,.5,1> translate <0,p18-1,0>}     //-- top tower nipple
    
    cone {<0,p18,0>,2,<0,p19,0>,1.5}                            //-- tooth pick
    sphere {<0,0,0>,10 translate <0,p19,0>}                     //-- top ball

    torus {27,1.5   translate <0,p13-5,0> }                         //-- top tower ring
    torus {26.5,1.5 translate <0,p14-5,0> }
    torus {26,1.5   translate <0,p15-5,0> }
    torus {25.5,1.5 translate <0,p16-5,0> }
    torus {25,1.5   translate <0,p17-5,0> }   
    
}




#declare tower_B =
union {
    difference {
        union {
            cone {<0,p0,0>,42,<0,p3,0>,35 }                     //-- tall base
            cone {<0,p0,0>,46,<0,p0-20,0>,46 }                  //-- tall base  
        }
        sphere {<0,0,0>, 1 scale <30,80,10> translate <0,0,-40>} 
        sphere {<0,0,0>, 1 scale <20,60,15> translate <0,0,-40>}
    } 
    sphere {<0,0,0>, 1 scale <21,21,21> translate <0,-30,-60>}  //-- porch ball
    cone {<0,0,0>,10,<0,23,0>,8 translate <0,-30,-60>}           //-- tooth pic
    
    cylinder {<0,p3,0>,<0,p4+10,0>, 37}                         //-- collar
    cylinder {<0,p4,0>,<0,p5,0>, 34}                            //-- collar 
    torus   {32,2   translate <0,p5,0> }
    sphere {<0,0,0>,30 translate <0,p5,0>}
    
    
    difference {
        cylinder {<-4,0,0>,<4,0,0>, 20}                           //-- collar
        cylinder {<-5,0,0>,<5,0,0>, 30 translate <0,10,-30>}      //-- collar
        translate <0,p5+40,-10>
    }
    
    #for (i,0,12)
        sphere {<0,0,0>,2 translate <37,p4,0> rotate <0,i*30,0>} 
    #end
} 



#declare base_A =
union {
    cone {<0,-300,0>,120,<0,p0,0>,110 }       //-- main base
    torus {105,5   translate <0,p0,0> } 
    
    cone {<0,-80,0>,115,<0,-10,0>,130 }       //-- main base ring
    torus {125,5   translate <0,-10,0> }
} 



//M_gold_metal
#declare _m_tower = M_gold_metal ;

//M_gold_metal
#declare ray_beam_tower = 
union {
    object { base_A translate <0,0,0> material {_m_tower} }
    object { tower_A translate <0,0,0> material {_m_tower} }    
    union {    
        object { tower_B rotate <0,0,0>   translate <0,0,-45> material {_m_tower} }
        object { tower_B rotate <0,90,0>  translate <-45,0,0> material {_m_tower} }
        object { tower_B rotate <0,-90,0> translate <45,0,0> material {_m_tower} } 
        object { tower_B rotate <0,180,0> translate <0,0,45> material {_m_tower} }
        translate <0,20,0>
    } 
}